
#ifndef _COMMON_H_
#define _COMMON_H_

#include <stdio.h>
#include "AD18F08.h"

typedef signed   char   int8_t;     //!< Signed 8 bit integer
typedef unsigned char   uint8_t;    //!< Unsigned 8 bit integer

typedef signed   short  int16_t;    //!< Signed 16 bit integer
typedef unsigned short  uint16_t;   //!< Unsigned 16 bit integer

typedef signed   long   int32_t;    //!< Signed 32 bit integer
typedef unsigned long   uint32_t;   //!< Unsigned 32 bit integer

typedef unsigned char   bool;     //!< Boolean data type

/*********************************************中断设置**************************************/
#define           H_SysPri_INIT_EN       0  //使能高优先级中断
#define           H_SysPri_INIT_Dis      1  //禁用高优先级中断
#define           L_SysPri_INIT_EN       2  //使能低优先级中断
#define           L_SysPri_INIT_Dis      3  //禁用低优先级中断

#define           INT_OFF                0  //禁用外设中断
#define           H_Pri_INT              1  //外设使能高优先级中断
#define           L_Pri_INT              2  //外设使能低优先级中断
/*********************************************中断设置**************************************/

/**********************************************TIMER*****************************************/

#define           T1_FOSC_1            0    //TIMER0预分频为1
#define           T1_FOSC_2            1    //TIMER0预分频为2
#define           T1_FOSC_4            2    //TIMER0预分频为4
#define           T1_FOSC_8            3    //TIMER0预分频为8

#define           T1CK_T1CKI           0    //TIMER0时钟源为T1CKI(PB5)
#define           T1CK_WDT             1    //TIMER0时钟源为WDT
#define           T1CK_2K              2    //TIMER0时钟源为内部2K
#define           T1CK_CMPOUT          3    //TIMER0时钟源是CMPOUT输出

#define           T1_FCPU              1    //使能TIMER0的时钟且不分频
#define           T1_FD                0    //使能TIMER0的时钟源分频

#define           T1_INT_EN            1    //使能TIMER0中断
#define           T1_INT_DIS           0    //禁止TIMER0中断

#define           T1CS_T1CKI           1    //选择T1CK[1:0]作为外设TIMER1的时钟
#define           T1CS_FCPU            0    //选择FCPU时钟外设TIMER1的时钟

#define           T1CH_0               0    //T1CH0作为脉宽检测输入信号(PB6)
#define           T1CH_1               1    //T1CH1作为脉宽检测输入信号(PB7)
#define           T1CH_2               2    //T1CH2作为脉宽检测输入信号(PA4)
#define           T1CH_3               3    //TMR2CLK作为脉宽检测输入信号(配置T2CON0<2>=1)

#define           T1M_0                0    //TIMER1工作在普通模式，溢出时间产生中断标志位。
#define           T1M_1                1    //脉宽测量模式0
#define           T1M_2                2    //脉宽测量模式1
#define           T1M_3                3    //模式2，TIMER1工作在定时模式，在定时产生中断时，启动ADC采集


// #define           T0_COUNT_P           0    //T0CKI脚上降沿触发计数
// #define           T0_COUNT_N           1    //T0CKI脚下降沿触发计数  
// #define           T0_BUZZEE_EN         1    //启动BUZZEE模式
// #define           T0_BUZZEE_DIS        0    //禁止BUZZEE模式


void GPIO_Init(void);
void timer0_Count(void);
void Timer1_Timer(void);
void Timer1_edge(void);
void Cmp_Cfg(unsigned char Pch,unsigned char Nch,unsigned char Mode);




#endif